# sudo apt install python3-MIDIUtil
from midiutil import MIDIFile

name = "Generate Midi"
keys = ['C','C#','D','D#','E','F','F#','G','G#','A','A#','B']
track = 0
time = 0 # In beats
channel = 0
semibreve = 4 # In beats
seminima = 1 # In beats
colcheia = 0.5 # In beats
volume = 100 # 0-127, as per the MIDI standard
tempo = 120 # In BPM
step = 48	

def gerar_pedal(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "Pedal")
	for i, chord in enumerate(acordes):
		pitch = keys.index(chord[:1],0) + step
		if (chord[1:2] == '#'):
			pitch = pitch + 1
		if (chord[1:2] == 'b'):
			pitch = pitch - 1
		mf.addNote(track, channel, pitch, i*4 + 0, seminima, volume)
		mf.addNote(track, channel, pitch, i*4 + 1, seminima, volume)
		mf.addNote(track, channel, pitch, i*4 + 2, seminima, volume)
		mf.addNote(track, channel, pitch, i*4 + 3, seminima, volume)
	track = track + 1

def gerar_tonica(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "Tonica")
	for i, chord in enumerate(acordes):
		pitch = keys.index(chord[:1],0) + step + 36
		if (chord[1:2] == '#'):
			pitch = pitch + 1
		if (chord[1:2] == 'b'):
			pitch = pitch - 1
		print("Tônica: ", chord, pitch)
		mf.addNote(track, channel, pitch, i*4, semibreve, volume)
	track = track + 1

def gerar_quinta(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "Quinta")
	for i, chord in enumerate(acordes):
		pitch = keys.index(chord[:1],0) + step + 36
		if (chord[1:2] == '#'):
			pitch = pitch + 1
		if (chord[1:2] == 'b'):
			pitch = pitch - 1
		pitch = pitch + 7
		print("Quinta: ", chord, pitch)
		mf.addNote(track, channel, pitch, i*4, semibreve, volume)
	track = track + 1

def gerar_terca(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "Terca")
	for i, chord in enumerate(acordes):
		pitch = keys.index(chord[:1],0) + step + 36
		if (chord[1:2] == '#'):
			pitch = pitch + 1
		if (chord[1:2] == 'b'):
			pitch = pitch - 1
		pitch = pitch + 4
		if ("m" in chord):
			pitch = pitch - 1
		print("terça: ", chord, pitch)
		mf.addNote(track, channel, pitch, i*4, semibreve, volume)
	track = track + 1

def gerar_acordes(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "acordes")
	for i, chord in enumerate(acordes):
		pitch = keys.index(chord[:1],0) + step + 24
		if (chord[1:2] == '#'):
			pitch = pitch + 1
		if (chord[1:2] == 'b'):
			pitch = pitch - 1
		mf.addNote(track, channel, pitch, i*4, semibreve, volume)
		quinta = pitch + 7
		mf.addNote(track, channel, quinta, i*4, semibreve, volume)
		terca = pitch + 4
		if ("m" in chord):
			terca = terca - 1
		mf.addNote(track, channel, terca, i*4, semibreve, volume)
	track = track + 1

def gerar_reaggae(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "reggae")
	for i, chord in enumerate(acordes):
		pitch = keys.index(chord[:1],0) + step + 24
		if (chord[1:2] == '#'):
			pitch = pitch + 1
		if (chord[1:2] == 'b'):
			pitch = pitch - 1
		quinta = pitch + 7
		terca = pitch + 4
		if ("m" in chord):
			terca = terca - 1
		mf.addNote(track, channel, pitch, i*4 + 1, seminima, volume)
		mf.addNote(track, channel, pitch, i*4 + 3, seminima, volume)
		mf.addNote(track, channel, terca, i*4 + 1, seminima, volume)
		mf.addNote(track, channel, terca, i*4 + 3, seminima, volume)
		mf.addNote(track, channel, quinta, i*4 + 1, seminima, volume)
		mf.addNote(track, channel, quinta, i*4 + 3, seminima, volume)
	track = track + 1

def gerar_baixo1(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "Baixo1")
	for i, chord in enumerate(acordes):
		pitch = keys.index(chord[:1],0) + step + 12
		if (chord[1:2] == '#'):
			pitch = pitch + 1
		if (chord[1:2] == 'b'):
			pitch = pitch - 1
		quinta = pitch + 7
		terca = pitch + 4
		if ("m" in chord):
			terca = terca - 1
		mf.addNote(track, channel, pitch, i*4 + 0, seminima + colcheia, volume)
		mf.addNote(track, channel, terca, i*4 + 1.5, colcheia, volume)
		mf.addNote(track, channel, quinta, i*4 + 2, seminima, volume)
		mf.addNote(track, channel, pitch, i*4 + 3, seminima, volume)
	track = track + 1

def gerar_baixo2(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "Baixo2")
	for i, chord in enumerate(acordes):
		pitch = keys.index(chord[:1],0) + step + 12
		mf.addNote(track, channel, pitch, i*4 + 0, seminima, volume)
		mf.addNote(track, channel, pitch + 7, i*4 + 1, seminima, volume)
		mf.addNote(track, channel, pitch, i*4 + 2, seminima, volume)
		mf.addNote(track, channel, pitch + 7, i*4 + 3, seminima, volume)
	track = track + 1

def gerar_baixo3(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "Baixo3")
	for i, chord in enumerate(acordes):
		pitch = keys.index(chord[:1],0) + step + 12
		mf.addNote(track, channel, pitch, i*4 + 0, colcheia, volume)
		mf.addNote(track, channel, pitch + 7, i*4 + 0.5, colcheia, volume)
		mf.addNote(track, channel, pitch, i*4 + 1, colcheia, volume)
		mf.addNote(track, channel, pitch + 7, i*4 + 1.5, colcheia, volume)
		mf.addNote(track, channel, pitch, i*4 + 2, colcheia, volume)
		mf.addNote(track, channel, pitch + 7, i*4 + 2.5, colcheia, volume)
		mf.addNote(track, channel, pitch, i*4 + 3, colcheia, volume)
		mf.addNote(track, channel, pitch + 7, i*4 + 3.5, colcheia, volume)
	track = track + 1


def gerar_bateria1(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "Bateria1")
	# Bumbo
	mf.addNote(track, channel, 48, 0, seminima, volume)
	mf.addNote(track, channel, 48, 4, seminima, volume)
	# Caixa
	mf.addNote(track, channel, 53, 2, seminima, volume)
	mf.addNote(track, channel, 53, 6, seminima, volume)
	# Cimbal
	mf.addNote(track, channel, 60, 0, colcheia, volume + 10)
	mf.addNote(track, channel, 61, 0.5, colcheia, volume - 10)
	mf.addNote(track, channel, 60, 1, colcheia, volume)
	mf.addNote(track, channel, 62, 1.5, colcheia, volume + 10)
	mf.addNote(track, channel, 61, 2, colcheia, volume - 10)
	mf.addNote(track, channel, 60, 2.5, colcheia, volume)
	mf.addNote(track, channel, 61, 3, colcheia, volume + 10)
	mf.addNote(track, channel, 62, 3.5, colcheia, volume - 10)
	mf.addNote(track, channel, 60, 4, colcheia, volume - 10)
	mf.addNote(track, channel, 61, 4.5, colcheia, volume + 10)
	mf.addNote(track, channel, 60, 5, colcheia, volume)
	mf.addNote(track, channel, 61, 5.5, colcheia, volume - 10)
	mf.addNote(track, channel, 62, 6, colcheia, volume + 10)
	mf.addNote(track, channel, 60, 6.5, colcheia, volume - 10)
	mf.addNote(track, channel, 61, 7, colcheia, volume - 10)
	mf.addNote(track, channel, 62, 7.5, colcheia, volume)
	track = track + 1

def gerar_bateria2(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "Bateria2")
	# Bumbo
	mf.addNote(track, channel, 48, 0, seminima, volume)
	mf.addNote(track, channel, 48, 2, colcheia, volume)
	mf.addNote(track, channel, 48, 2.5, colcheia, volume)
	mf.addNote(track, channel, 48, 4, seminima, volume)
	mf.addNote(track, channel, 48, 6, colcheia, volume)
	mf.addNote(track, channel, 48, 6.5, colcheia, volume)
	# Caixa
	mf.addNote(track, channel, 53, 1, seminima, volume)
	mf.addNote(track, channel, 53, 3, seminima, volume)
	mf.addNote(track, channel, 53, 5, seminima, volume)
	mf.addNote(track, channel, 53, 7, seminima, volume)
	# Cimbal
	mf.addNote(track, channel, 60, 0, colcheia, volume + 10)
	mf.addNote(track, channel, 61, 0.5, colcheia, volume - 10)
	mf.addNote(track, channel, 60, 1, colcheia, volume)
	mf.addNote(track, channel, 62, 1.5, colcheia, volume + 10)
	mf.addNote(track, channel, 61, 2, colcheia, volume - 10)
	mf.addNote(track, channel, 60, 2.5, colcheia, volume)
	mf.addNote(track, channel, 61, 3, colcheia, volume + 10)
	mf.addNote(track, channel, 62, 3.5, colcheia, volume - 10)
	mf.addNote(track, channel, 60, 4, colcheia, volume - 10)
	mf.addNote(track, channel, 61, 4.5, colcheia, volume + 10)
	mf.addNote(track, channel, 60, 5, colcheia, volume)
	mf.addNote(track, channel, 61, 5.5, colcheia, volume - 10)
	mf.addNote(track, channel, 62, 6, colcheia, volume + 10)
	mf.addNote(track, channel, 60, 6.5, colcheia, volume - 10)
	mf.addNote(track, channel, 61, 7, colcheia, volume - 10)
	mf.addNote(track, channel, 62, 7.5, colcheia, volume)
	track = track + 1

def gerar_percussao(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "Percussao")
	# Bumbo
	mf.addNote(track, channel, 72, 0, seminima, volume)
	mf.addNote(track, channel, 73, 0.5, seminima, volume)
	mf.addNote(track, channel, 73, 3, seminima, volume)
	mf.addNote(track, channel, 72, 3.5, seminima, volume)
	mf.addNote(track, channel, 73, 5, seminima, volume)
	mf.addNote(track, channel, 72, 5.5, seminima, volume)
	mf.addNote(track, channel, 72, 6.5, seminima, volume)
	track = track + 1

def gerar_percussao2(acordes, mf):
	global track, channel, time, duration, volume
	mf.addTrackName(track, time, "Percussao 2")
	# Bumbo
	mf.addNote(track, channel, 77, 0.5, colcheia, volume)
	mf.addNote(track, channel, 78, 1.5, colcheia, volume)
	mf.addNote(track, channel, 79, 2, colcheia, volume)
	mf.addNote(track, channel, 77, 2.5, colcheia, volume)
	mf.addNote(track, channel, 79, 3, colcheia, volume)
	track = track + 1

mf = MIDIFile(13, deinterleave=True) # One track, defaults to format 1 (tempo track is created 

# name = "Alagados"
# acordes = ['A', 'A', 'E', 'D']
# mf.addTempo(track, time, 200)

# name = "Vapor Barato"
# acordes = ['Am', 'Am', 'G', 'G', 'F', 'F', 'Dm', 'E']
# mf.addTempo(track, time, 132)

# name = "Hey Joe"
# acordes = ['C', 'G', 'D', 'A', 'E', 'E', 'E', 'E']
# mf.addTempo(track, time, 132)

# name = "Ainda é cedo"
# acordes = ['Dm', 'C', 'Am', 'Am']
# mf.addTempo(track, time, 132)

# name = "Creep"
# acordes = ['G', 'G', 'B', 'B', 'C', 'C', 'Cm', 'Cm']
# mf.addTempo(track, time, 100)

# name = "Não chores mais"
# acordes = ['C', 'G', 'Am', 'F']
# mf.addTempo(track, time, 100)

name = "Naquela Mesa"
acordes = ['Am', 'Am', 'Am', 'Dm', 'Dm', 'Dm', 'Dm', 'Am', 'Am', 'Am', 'A', 'Dm', 'Dm', 'Am', 'E', 'Am']
mf.addTempo(track, time, 100)

gerar_bateria1(acordes,mf)
gerar_bateria2(acordes,mf)
gerar_percussao(acordes,mf) 
gerar_percussao2(acordes,mf)
gerar_tonica(acordes,mf)
gerar_quinta(acordes,mf)
gerar_terca(acordes,mf)
gerar_acordes(acordes,mf)
gerar_reaggae(acordes,mf)
gerar_pedal(acordes,mf)
gerar_baixo1(acordes,mf)
gerar_baixo2(acordes,mf)
gerar_baixo3(acordes,mf)
with open(name + ".mid", "wb") as output_file:
    mf.writeFile(output_file)